#ifndef _IOWARRIOR_H_
#define _IOWARRIOR_H_

/* Version Information */
#define DRIVER_VERSION "v0.3.1"
#define DRIVER_AUTHOR "Christian Lucht <lucht@codemercs.com>"
#define DRIVER_DESC "USB I/O-Warrior driver (Linux 2.6.x)"


/* Define these values to match your device */
#define USB_VENDOR_ID_CODEMERCS	1984
#define USB_DEVICE_ID_CODEMERCS_IOW40	0x1500
#define USB_DEVICE_ID_CODEMERCS_IOW24	0x1501
#define USB_DEVICE_ID_CODEMERCS_IOW48	0x1502
#define USB_DEVICE_ID_CODEMERCS_IOW28	0x1503

#define CODEMERCS_MAGIC_NUMBER	0xC0	// like COde Mercenaries

/* Define the ioctl commands */
#define IOW_WRITE	_IOW(CODEMERCS_MAGIC_NUMBER, 1, long)
#define IOW_READ	_IOW(CODEMERCS_MAGIC_NUMBER, 2, long)

/* Get a minor range for your devices from the usb maintainer */
#define IOWARRIOR_MINOR_BASE	208		// SKELETON_MINOR_BASE 192 + 16, not offical yet

/* we can have up to this number of device plugged in at once */
#define MAX_DEVICES		16

/* interrupt input queue size */
#define MAX_INTERRUPT_BUFFER 16

#endif  // _IOWARRIOR_H_
